/*
 * Decompiled with CFR 0.152.
 */
package org.anser.proj.timc.app.agents.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.util.Stack;
import org.anser.proj.timc.lang.StringLib;
import org.anser.proj.timc.security.MessageDigestLib;
import org.anser.proj.timc.util.ArgumentsLib;

public class FileRegistrar {
    public static String VERSION = "1.0";
    public static String PRODUCT_NAME = "FileRegistrar";
    public static String INTRO = String.valueOf(PRODUCT_NAME) + " v" + VERSION + " (C) Copyright 1998 Analytic Services, Inc.";
    public static String HELP = "\n" + INTRO + "\n" + "\n" + "Reads a file or a directory of files, calculates their SHA-1\n" + "message digests, and stores the results in a text output file.\n" + "If the output file already exists, it will append the new\n" + "contents to the old.\n" + "\n" + PRODUCT_NAME + " accepts two arguments:\n" + "1:  the name of the file or the directory of files to register\n" + "2:  the name of the output file (defaults to the console)\n" + "\n" + "Options:\n" + "+r:  recursively follow sub-directories\n" + "+v:  verbose, print filenames scanned\n" + "\n" + "Example:\n" + "java org.anser.proj.timc.app.agents.file.FileRegistrar " + "+r +v C:\\ out.txt\n";

    public static void calculate(String[] stringArray) throws Exception {
        PrintStream printStream;
        if (ArgumentsLib.requestsHelp(stringArray)) {
            System.out.println(HELP);
        }
        String[] stringArray2 = ArgumentsLib.getOptions(stringArray);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < stringArray2.length) {
            if (stringArray2[n].equals("+r")) {
                bl = true;
            } else if (stringArray2[n].equals("+v")) {
                bl2 = true;
            } else {
                System.out.println(HELP);
                System.out.println("Unknown option:  \"" + stringArray2[n] + "\"");
                return;
            }
            ++n;
        }
        if ((stringArray = ArgumentsLib.removeOptions(stringArray)).length < 1 || stringArray.length > 2 || stringArray.length > 1 && stringArray[0].equals(stringArray[1])) {
            System.out.println(HELP);
            return;
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            System.out.println("File \"" + stringArray[0] + "\" does not exist.");
            System.out.println(HELP);
            return;
        }
        boolean bl3 = false;
        File file2 = null;
        if (stringArray.length < 2) {
            printStream = System.out;
            bl3 = true;
        } else {
            file2 = new File(stringArray[1]);
            if (file2.exists()) {
                System.out.println("Appending to existing results file.");
            }
            printStream = new PrintStream(new FileOutputStream(stringArray[1], true));
        }
        try {
            FileRegistrar.printFileData(file, file2, printStream, bl, bl2, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(HELP);
            System.out.println(illegalArgumentException.getMessage());
        }
        if (!bl3) {
            printStream.flush();
            printStream.close();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        FileRegistrar.calculate(stringArray);
    }

    public static void printFileData(File file, File file2, PrintStream printStream, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, NoSuchAlgorithmException {
        Stack stack = new Stack();
        FileRegistrar.push(stack, file);
        while (!stack.isEmpty()) {
            String string = (String)stack.pop();
            File file3 = new File(string);
            if (file3.isDirectory()) {
                if (!bl) continue;
                FileRegistrar.push(stack, file3);
                continue;
            }
            if (file2 != null && file3.equals(file2)) continue;
            if (bl2) {
                System.out.println(file3.getCanonicalPath());
            }
            try {
                FileRegistrar.printFileData(file3, printStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (bl3) {
                    System.err.println("File \"" + file3.getCanonicalPath() + "\" not found or in use.");
                }
                if (!bl4) continue;
                throw fileNotFoundException;
            }
        }
    }

    public static void printFileData(File file, PrintStream printStream) throws IOException, NoSuchAlgorithmException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        printStream.println(String.valueOf(MessageDigestLib.toString(MessageDigestLib.createDigest(bufferedInputStream))) + " " + StringLib.padLeft(String.valueOf(file.length()) + " ", '0', 13) + file.getCanonicalPath());
    }

    private static void push(Stack stack, File file) throws IOException {
        if (file.isFile()) {
            stack.push(file.getCanonicalPath());
        } else if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = stringArray.length - 1;
            while (n > -1) {
                File file2 = new File(file, stringArray[n]);
                stack.push(file2.getCanonicalPath());
                --n;
            }
        } else {
            throw new IllegalArgumentException("\"" + file.getCanonicalPath() + "\" is neither a file nor a directory.");
        }
    }
}

