/*
 * Decompiled with CFR 0.152.
 */
package org.anser.proj.timc.misc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Base64Converter {
    public static final char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static byte[] computeFileDigest(String string, String string2) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(string)));
        MessageDigest messageDigest = MessageDigest.getInstance(string2);
        while ((n = ((InputStream)bufferedInputStream).read()) > -1) {
            messageDigest.update((byte)n);
        }
        return messageDigest.digest();
    }

    public static String computeFileFingerprint(String string, String string2) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        return String.valueOf(string2) + "-Digest: " + Base64Converter.encode(Base64Converter.computeFileDigest(string, string2));
    }

    public static byte[] decode(String string) {
        return Base64Converter.decode(string.toCharArray());
    }

    public static byte[] decode(char[] cArray) {
        if (cArray.length == 0) {
            return new byte[0];
        }
        int n = cArray.length;
        while (cArray[n - 1] == '=') {
            --n;
        }
        int n2 = 6 * n / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < 4) {
                int n7 = -1;
                int n8 = 0;
                while (n8 < alphabet.length) {
                    if (cArray[n4] == alphabet[n8]) {
                        n7 = n8;
                        break;
                    }
                    ++n8;
                }
                n5 |= (n7 & 0xFF) << 18 - 6 * n6;
                if (++n4 == n) break;
                ++n6;
            }
            byArray[n3++] = (byte)((n5 & 0xFF0000) >> 16);
            if (n3 < n2) {
                byArray[n3++] = (byte)((n5 & 0xFF00) >> 8);
            }
            if (n3 >= n2) continue;
            byArray[n3++] = (byte)(n5 & 0xFF);
        }
        return byArray;
    }

    public static String encode(String string) {
        return Base64Converter.encode(string.getBytes());
    }

    public static String encode(byte[] byArray) {
        int n;
        int n2;
        if (byArray.length == 0) {
            return "";
        }
        char[] cArray = new char[((byArray.length - 1) / 3 + 1) * 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 + 3 <= byArray.length) {
            n2 = (byArray[n4++] & 0xFF) << 16;
            n2 |= (byArray[n4++] & 0xFF) << 8;
            n = ((n2 |= byArray[n4++] & 0xFF) & 0xFC0000) >> 18;
            cArray[n3++] = alphabet[n];
            n = (n2 & 0x3F000) >> 12;
            cArray[n3++] = alphabet[n];
            n = (n2 & 0xFC0) >> 6;
            cArray[n3++] = alphabet[n];
            n = n2 & 0x3F;
            cArray[n3++] = alphabet[n];
        }
        if (byArray.length - n4 == 2) {
            n2 = (byArray[n4] & 0xFF) << 16;
            n = ((n2 |= (byArray[n4 + 1] & 0xFF) << 8) & 0xFC0000) >> 18;
            cArray[n3++] = alphabet[n];
            n = (n2 & 0x3F000) >> 12;
            cArray[n3++] = alphabet[n];
            n = (n2 & 0xFC0) >> 6;
            cArray[n3++] = alphabet[n];
            cArray[n3++] = 61;
        } else if (byArray.length - n4 == 1) {
            n2 = (byArray[n4] & 0xFF) << 16;
            n = (n2 & 0xFC0000) >> 18;
            cArray[n3++] = alphabet[n];
            n = (n2 & 0x3F000) >> 12;
            cArray[n3++] = alphabet[n];
            cArray[n3++] = 61;
            cArray[n3++] = 61;
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) {
        System.out.println(Base64Converter.test());
    }

    public static boolean test() {
        String[] stringArray = new String[]{"Hello there!", "test 2", "", "test 123", "David Wallace Croft", "croft@alumni.caltech.edu", "http://www.alumni.caltech.edu/~croft/"};
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            String string = Base64Converter.encode(stringArray[n]);
            String string2 = new String(Base64Converter.decode(string));
            bl &= stringArray[n].equals(string2);
            ++n;
        }
        return bl;
    }
}

