/*
 * Decompiled with CFR 0.152.
 */
package org.anser.proj.timc.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.anser.proj.timc.misc.Base64Converter;

public final class MessageDigestLib {
    private MessageDigestLib() {
    }

    public static byte[] createDigest(BufferedInputStream bufferedInputStream) throws IOException, NoSuchAlgorithmException {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        while ((n = bufferedInputStream.read()) != -1) {
            messageDigest.update((byte)n);
        }
        bufferedInputStream.close();
        return messageDigest.digest();
    }

    public static byte[] createDigest(File file) throws IOException, NoSuchAlgorithmException {
        return MessageDigestLib.createDigest(new FileInputStream(file));
    }

    public static byte[] createDigest(FileInputStream fileInputStream) throws IOException, NoSuchAlgorithmException {
        return MessageDigestLib.createDigest(new BufferedInputStream(fileInputStream));
    }

    public static byte[] createDigest(String string) throws IOException, MalformedURLException, NoSuchAlgorithmException {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        return MessageDigestLib.createDigest(bufferedInputStream);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(MessageDigestLib.toString(MessageDigestLib.createDigest(stringArray[0])));
    }

    public static String toString(byte[] byArray) {
        return Base64Converter.encode(byArray);
    }
}

