/*
 * Decompiled with CFR 0.152.
 */
package org.anser.proj.timc.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.anser.proj.timc.lang.StringLib;

public final class FileLib {
    private FileLib() {
    }

    public static long countTextFileLines(File file, boolean bl) throws FileNotFoundException, IOException {
        String string;
        long l = 0L;
        if (!file.isFile()) {
            return 0L;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if (!bl && string.trim().length() <= 0) continue;
            ++l;
        }
        return l;
    }

    public static String getExtension(File file) {
        return FileLib.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static String getFullPath(File file) {
        int n;
        String string = file.getAbsolutePath();
        string = StringLib.replace(string, "/", File.separator);
        if ((string = StringLib.replace(string, "\\", File.separator)).endsWith(String.valueOf(File.separator) + ".") || string.endsWith("..")) {
            string = String.valueOf(string) + File.separator;
        }
        while ((n = string.indexOf(String.valueOf(File.separator) + "." + File.separator)) > -1) {
            string = String.valueOf(string.substring(0, n)) + string.substring(n + File.separator.length() + 1);
        }
        while ((n = string.indexOf(String.valueOf(File.separator) + "..")) > -1) {
            int n2 = string.indexOf(File.separator, n + 1);
            int n3 = n2 - n - File.separator.length();
            int n4 = n;
            int n5 = 0;
            while (n5 < n3 - 1) {
                n4 = string.substring(0, n4).lastIndexOf(File.separator);
                ++n5;
            }
            string = String.valueOf(string.substring(0, n4)) + string.substring(n2);
        }
        return string;
    }

    public static String getRelativePath(File file, File file2) {
        String string = FileLib.getFullPath(file);
        String string2 = FileLib.getFullPath(file2);
        if (!string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        if (FileLib.isInBranch(string, string2, File.separator)) {
            if (string2.length() < string.length()) {
                return string.substring(string2.length());
            }
            return "";
        }
        throw new IllegalArgumentException("file not in baseDir branch");
    }

    public static boolean isInBranch(String string, String string2, String string3) {
        if (!string2.endsWith(string3)) {
            throw new IllegalArgumentException("\"branch\" must end with the file separator");
        }
        if (string.startsWith(string2)) {
            return true;
        }
        return (String.valueOf(string) + string3).startsWith(string2);
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(new File("C:").getCanonicalPath());
            System.out.println(FileLib.getFullPath(new File("alpha/delta/./file.txt")));
            System.out.println(FileLib.getFullPath(new File("alpha/bravo/../delta/file.txt")));
            System.out.println(FileLib.getFullPath(new File("alpha/bravo/charlie/.../delta/file.txt")));
            System.out.println(FileLib.getFullPath(new File(".")));
            System.out.println(FileLib.getFullPath(new File("..")));
            System.out.println(FileLib.getFullPath(new File("..\\")));
            System.out.println(FileLib.getFullPath(new File("J:\\")));
            System.out.println(FileLib.getFullPath(new File("C:\\")));
            System.out.println(FileLib.getFullPath(new File("C:")));
            System.out.println("\"" + FileLib.getExtension("billy.") + "\"");
            System.out.println("line count:  " + FileLib.countTextFileLines(new File("FileLib.java"), false));
            System.out.println("line count:  " + FileLib.countTextFileLines(new File("FileLib.java"), true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean makeParents(String string) {
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 == null) {
            return false;
        }
        File file2 = new File(string2);
        return file2.mkdirs();
    }

    public static String readFile(String string) throws IOException, FileNotFoundException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        StringWriter stringWriter = new StringWriter();
        while ((n = bufferedInputStream.read()) != -1) {
            stringWriter.write(n);
        }
        return stringWriter.toString();
    }

    public static String readTextFile(String string) throws IOException, FileNotFoundException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, false);
        while ((string2 = bufferedReader.readLine()) != null) {
            printWriter.println(string2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }
}

