/*
 * Decompiled with CFR 0.152.
 */
package org.anser.proj.timc.prog.croft.app.siteretriever;

import java.net.URL;
import java.util.List;
import org.anser.proj.timc.prog.croft.app.siteretriever.SiteRetrieverRunner;
import org.anser.proj.timc.prog.croft.net.robots.RobotsTxtListener;
import org.anser.proj.timc.prog.croft.net.web.EthicalWebSearch;
import org.anser.proj.timc.prog.croft.net.web.EthicalWebSearchStrategy;
import org.anser.proj.timc.prog.croft.net.web.HTMLLib;
import org.anser.proj.timc.prog.croft.net.web.NodeListFilter;
import org.anser.proj.timc.prog.croft.net.web.URLNode;
import org.anser.proj.timc.util.ArgumentsLib;
import org.anser.proj.timc.util.search.SearchLoop;
import org.anser.proj.timc.util.search.SearchLoopListener;

public class SiteRetriever
extends EthicalWebSearch
implements NodeListFilter,
SearchLoopListener,
RobotsTxtListener {
    public static final String HELP = "\nSiteRetriever Copyright 1998-1999 Analytic Services, Inc.\nVersion 1.0a1, 1999-02-05\nhttp://nexos.anser.org:8080/java/app/siteretriever/\nDavid Wallace Croft, croftd@anser.org\n\nDownloads an entire web site and copies its content hierarchy\nto a local directory.\n\nCommand-line Arguments:\n  1.  your e-mail address;\n  2.  root of web site branch to download; and\n  3.  local destination directory.\n\nExample:\njava -jar SiteRetriever.jar croftd@anser.org http://www.anser.org/ C:\\mirror\\\n";
    protected URL rootURL;

    public SiteRetriever(String string, long l, URL uRL) {
        super(string, l);
        this.rootURL = uRL;
        EthicalWebSearchStrategy ethicalWebSearchStrategy = this.getEthicalWebSearchStrategy();
        ethicalWebSearchStrategy.addNodeListFilter(this);
        ethicalWebSearchStrategy.addRobotsTxtListener(this);
        this.getSearchLoop().addSearchLoopListener(this);
    }

    public void forbiddenByRobotsTxt(String string) {
        System.out.println("FORBIDDEN by ROBOTS.TXT:  \n" + string);
    }

    public boolean isNodeListFiltrate(Object object) {
        URL uRL = ((URLNode)object).getURL();
        return HTMLLib.isInBranch(uRL, this.rootURL);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 3 || ArgumentsLib.requestsHelp(stringArray)) {
                System.out.println(HELP);
                return;
            }
            URL uRL = new URL(stringArray[1]);
            SiteRetriever siteRetriever = new SiteRetriever(stringArray[0], 100L, uRL);
            URLNode uRLNode = new URLNode(uRL);
            siteRetriever.addInputStreamConsumer(new SiteRetrieverRunner(stringArray[2]));
            if (siteRetriever.push(uRLNode)) {
                siteRetriever.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(HELP);
        }
    }

    public void searchLoopCurrentNode(SearchLoop searchLoop, Object object) {
        System.out.println("Scanning " + object);
    }

    public void searchLoopLinkedNodes(SearchLoop searchLoop, Object object, List list) {
        System.out.println("Found " + (list == null ? 0 : list.size()) + " hyperlinks in " + object);
    }
}

