/*
 * Decompiled with CFR 0.152.
 */
package org.anser.proj.timc.prog.croft.net.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.anser.proj.timc.prog.croft.net.robots.RobotsTxt;
import org.anser.proj.timc.prog.croft.net.robots.RobotsTxtListener;
import org.anser.proj.timc.prog.croft.net.web.URLNode;
import org.anser.proj.timc.prog.croft.net.web.WebSearchStrategy;

public class EthicalWebSearchStrategy
extends WebSearchStrategy {
    protected String userAgent;
    protected List hostsAsked = new LinkedList();
    protected Map hostRobotsTxt = new HashMap();
    protected List robotsTxtListeners = new LinkedList();

    public EthicalWebSearchStrategy(String string, List list) {
        super(list);
        this.userAgent = string;
    }

    public boolean addRobotsTxtListener(RobotsTxtListener robotsTxtListener) {
        return this.robotsTxtListeners.add(robotsTxtListener);
    }

    public Map getHostRobotsTxt() {
        return this.hostRobotsTxt;
    }

    public List getHostsAsked() {
        return this.hostsAsked;
    }

    protected boolean isAllowedByRobotsTxt(URL uRL) {
        RobotsTxt robotsTxt;
        String string = uRL.getHost();
        int n = uRL.getPort();
        String string2 = string;
        if (n != 80 && n != -1) {
            string2 = String.valueOf(string2) + ":" + n;
        }
        if (!this.hostsAsked.contains(string2)) {
            this.hostsAsked.add(string2);
            robotsTxt = null;
            try {
                System.out.print("PARSING robots.txt at " + string + ":" + (n == -1 ? 80 : n) + "...");
                robotsTxt = RobotsTxt.parseRobotsTxt(string, n);
                System.out.println("parsed.");
            }
            catch (Exception exception) {}
            if (robotsTxt != null) {
                this.hostRobotsTxt.put(string2, robotsTxt);
            }
        }
        if ((robotsTxt = (RobotsTxt)this.hostRobotsTxt.get(string2)) == null) {
            return true;
        }
        try {
            return robotsTxt.isAllowed(this.userAgent, uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException.getMessage());
        }
    }

    public boolean isScannable(Object object) {
        URLNode uRLNode = (URLNode)object;
        URL uRL = uRLNode.getURL();
        if (!this.isAllowedByRobotsTxt(uRL)) {
            uRLNode.setException("Forbidden by robots.txt");
            Object[] objectArray = this.robotsTxtListeners.toArray();
            int n = 0;
            while (n < objectArray.length) {
                RobotsTxtListener robotsTxtListener = (RobotsTxtListener)objectArray[n];
                robotsTxtListener.forbiddenByRobotsTxt(uRL.toString());
                ++n;
            }
            return false;
        }
        return true;
    }

    public Object next() {
        Object object;
        while ((object = super.next()) != null) {
            if (!this.isScannable(object)) continue;
            return object;
        }
        return null;
    }

    public boolean removeRobotsTxtListener(RobotsTxtListener robotsTxtListener) {
        return this.robotsTxtListeners.remove(robotsTxtListener);
    }
}

