/*
 * Decompiled with CFR 0.152.
 */
package org.anser.proj.timc.util.search;

import java.util.Vector;
import org.anser.proj.timc.lang.event.RunListener;
import org.anser.proj.timc.lang.event.RunSource;
import org.anser.proj.timc.util.search.Lifecycle;
import org.anser.proj.timc.util.search.Loopable;

public class LoopLifecycle
implements Lifecycle,
RunSource {
    protected static final int EVENT_RUN_BEGAN = 1;
    protected static final int EVENT_RUN_ENDED = 2;
    protected static final int EVENT_RUN_ERROR = 3;
    protected Loopable loopable;
    protected Thread thread;
    protected boolean doLoop;
    private boolean running;
    private Vector runListeners = new Vector();

    public LoopLifecycle(Loopable loopable) {
        this.loopable = loopable;
    }

    public void addRunListener(RunListener runListener) {
        this.runListeners.add(runListener);
    }

    protected synchronized void broadcastRunEvent(int n, Throwable throwable) {
        Object[] objectArray = this.runListeners.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            RunListener runListener = (RunListener)objectArray[n2];
            if (n == 1) {
                runListener.runBegan(this);
            } else if (n == 2) {
                runListener.runEnded(this);
            } else if (n == 3) {
                runListener.runError(this, throwable);
            } else {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
    }

    public void destroy() {
    }

    public Loopable getLoopable() {
        return this.loopable;
    }

    public void init() {
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean removeRunListener(RunListener runListener) {
        return this.runListeners.remove(runListener);
    }

    public final void run() {
        if (Thread.currentThread() != this.thread) {
            return;
        }
        try {
            try {
                this.running = true;
                boolean bl = true;
                this.broadcastRunEvent(1, null);
                while (this.doLoop && bl) {
                    bl = this.loopable.loop();
                }
            }
            catch (Throwable throwable) {
                this.broadcastRunEvent(3, throwable);
            }
            Object var2_3 = null;
            this.doLoop = false;
            this.thread = null;
            this.running = false;
            this.broadcastRunEvent(2, null);
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.doLoop = false;
            this.thread = null;
            this.running = false;
            this.broadcastRunEvent(2, null);
            throw throwable;
        }
    }

    public final void start() {
        if (this.running || this.thread != null) {
            return;
        }
        this.doLoop = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public final void stop() {
        this.doLoop = false;
        this.thread = null;
    }
}

