/*
 * Decompiled with CFR 0.152.
 */
package org.anser.proj.timc.util.search;

import java.util.LinkedList;
import java.util.List;
import org.anser.proj.timc.util.search.Loopable;
import org.anser.proj.timc.util.search.SearchLoopListener;
import org.anser.proj.timc.util.search.Searchable;

public class SearchLoop
implements Loopable {
    protected Searchable searchable;
    protected Object currentNode;
    protected LinkedList searchLoopListeners = new LinkedList();

    public SearchLoop(Searchable searchable) {
        this.searchable = searchable;
    }

    public void addSearchLoopListener(SearchLoopListener searchLoopListener) {
        this.searchLoopListeners.add(searchLoopListener);
    }

    private void broadcastCurrentNode() {
        Object[] objectArray = this.searchLoopListeners.toArray();
        int n = 0;
        while (n < objectArray.length) {
            SearchLoopListener searchLoopListener = (SearchLoopListener)objectArray[n];
            searchLoopListener.searchLoopCurrentNode(this, this.currentNode);
            ++n;
        }
    }

    private void broadcastLinkedNodes(List list) {
        Object[] objectArray = this.searchLoopListeners.toArray();
        int n = 0;
        while (n < objectArray.length) {
            SearchLoopListener searchLoopListener = (SearchLoopListener)objectArray[n];
            searchLoopListener.searchLoopLinkedNodes(this, this.currentNode, list);
            ++n;
        }
    }

    public Object getCurrentNode() {
        return this.currentNode;
    }

    public boolean loop() {
        this.currentNode = this.searchable.next();
        this.broadcastCurrentNode();
        if (this.currentNode == null) {
            return false;
        }
        List list = this.searchable.scan(this.currentNode);
        this.broadcastLinkedNodes(list);
        if (list != null) {
            this.searchable.insert(list);
        }
        return true;
    }

    public boolean removeSearchLoopListener(SearchLoopListener searchLoopListener) {
        return this.searchLoopListeners.remove(searchLoopListener);
    }
}

